// SUIntegrationDefs.h : macros and constants used by the Serv-U Integration DLL
//

// prevent multiple inclusions of this file
#pragma once

/////////////////////////////////////////////////////////////////////////////
// define the target OS

#ifdef __linux__

	/////////////////////////////////////////////////////////////////////////////
	// building for Linux
	#define SUIN_LINUX

	// Linux includes
	#include <string.h>
	#include <stdio.h>
	#include <stdint.h>

	/////////////////////////////////////////////////////////////////////////////
	// LINUX specific declarations

	/////////////////////////////////////////////////////////////////////////////
	// typedefs
	typedef char										SUIN_TCHAR;						// text character
	typedef char										*SUIN_PTCHAR;					// pointer to text character
	typedef char										*SUIN_PTSTR;					// pointer to text characters
	typedef const char									*SUIN_PCTSTR;					// pointer to constant text characters
	typedef char										SUIN_CHAR;						// character
	typedef char										*SUIN_PCHAR;					// pointer to character
	typedef	char										*SUIN_PSTR;						// pointer to character string
	typedef	const char									*SUIN_PCSTR;					// pointer to constant character string

	typedef unsigned int								UINT;
	typedef int											BOOL;
	typedef	uint64_t									ULONGLONG;
	typedef void										VOID, *PVOID, *HANDLE, *HMODULE;

	/////////////////////////////////////////////////////////////////////////////
	// macros
	#ifndef SUIN_API
		#define SUIN_API																// API function prefix
	#endif
	#define SUIN_CALLBACK																// Callback function prefix

	/////////////////////////////////////////////////////////////////////////////
	// exported functions
	#define EXPORTED_FUNCTIONS_BEGIN					extern "C" {
	#define EXPORTED_FUNCTIONS_END						}

	// text macros
	#define SUIN_TXTCPY(dest, len, src)					strncpy(dest, src, len)			// text copy
	#define SUIN_TXTCMP(s1, s2)							strcmp(s1, s2)					// text case-sensitive compare
	#define SUIN_TXTICMP(s1, s2)						strcasecmp(s1, s2)				// text insensitive compare
	#define SUIN_TXTLEN(s1)								strlen(s1)						// text length

	// misc macros
	#define SUIN_TSPRINTF								snprintf						// text string printf
	#define FALSE										0								// false for BOOL type
	#define TRUE										(! FALSE)						// true for BOOL type
	#ifndef MAX_PATH
		#define MAX_PATH								260								// maximum characters in path name
	#endif
	#define _T(Val)										Val
	#define SUIN_ROOTFOLDER								_T("/")							// file system root folder
#else

	/////////////////////////////////////////////////////////////////////////////
	// building for Microsoft Windows
	#define SUIN_WINDOWS

	/////////////////////////////////////////////////////////////////////////////
	// Microsoft Windows specific declarations

	/////////////////////////////////////////////////////////////////////////////
	// typedefs
	typedef WCHAR										SUIN_TCHAR;						// text character
	typedef WCHAR										*SUIN_PTCHAR;					// pointer to text character
	typedef PWSTR										SUIN_PTSTR;						// pointer to text characters
	typedef PCWSTR										SUIN_PCTSTR;					// pointer to constant text characters
	typedef char										SUIN_CHAR;						// character
	typedef char										*SUIN_PCHAR;					// pointer to character
	typedef	char										*SUIN_PSTR;						// pointer to character string
	typedef	const char									*SUIN_PCSTR;					// pointer to constant character string

	/////////////////////////////////////////////////////////////////////////////
	// macros
	#define SUIN_API									WINAPI							// Windows API function prefix
	#define SUIN_CALLBACK								CALLBACK						// Callback function prefix

	/////////////////////////////////////////////////////////////////////////////
	// exported functions
	#define EXPORTED_FUNCTIONS_BEGIN
	#define EXPORTED_FUNCTIONS_END

	// text macros
	#define SUIN_TXTCPY(dest, len, src)					wcscpy_s(dest, len, src)		// string copy
	#define SUIN_TXTCMP(s1, s2)							wcscmp(s1, s2)					// string case-sensitive compare
	#define SUIN_TXTICMP(s1, s2)						_wcsicmp(s1, s2)				// string case-insensitive compare
	#define SUIN_TXTLEN(s1)								wcslen(s1)						// string length

	// misc macros
	#define SUIN_TSPRINTF								swprintf_s						// text string printf
	#define SUIN_ROOTFOLDER								_T("\\")							// file system root folder
#endif // __linux__

/////////////////////////////////////////////////////////////////////////////
// macros
#define SUIN_OK											SUIN_OKAY

/////////////////////////////////////////////////////////////////////////////
// codes
const UINT	SUIN_OKAY									= 0;
const UINT	SUIN_FAIL									= 1;
// SUUAChangePassword() error results
const UINT	SUIN_CHG_PASSWORD_NO_CURRENT_PASSWORD_MATCH	= 10;
const UINT	SUIN_CHG_PASSWORD_TOO_SHORT					= 11;
const UINT	SUIN_CHG_PASSWORD_NOT_COMPLEX				= 12;
const UINT	SUIN_CHG_PASSWORD_CURRENT_NEW_MATCH			= 13;
const UINT	SUIN_CHG_PASSWORD_CANT_CHANGE_ANONYMOUS		= 14;
const UINT	SUIN_CHG_PASSWORD_NEW_CANNOT_BE_EMPTY		= 15;
// operation hook error results
const UINT	SUIN_PERMISSION_DENIED						= 20;
const UINT	SUIN_INVALID_PARAMETER						= 21;
const UINT	SUIN_NOT_FOUND								= 22;
const UINT	SUIN_INTERNAL_ERROR							= 23;
const UINT	SUIN_ALREADY_EXISTS							= 24;
const UINT	SUIN_FILE_IS_DIR							= 25;
const UINT	SUIN_DIR_IS_FILE							= 26;
const UINT	SUIN_NO_SUCH_PATH							= 27;
const UINT	SUIN_INVALID_PATH							= 28;

/////////////////////////////////////////////////////////////////////////////
// directory access macros
// files
#define SUIN_DIR_ACCESS_READ							0x00000001						// read
#define SUIN_DIR_ACCESS_WRITE							0x00000002						// write
#define SUIN_DIR_ACCESS_APPEND							0x00000004						// append
#define SUIN_DIR_ACCESS_DELETE							0x00000008						// delete
#define SUIN_DIR_ACCESS_RENAME							0x00000010						// rename
#define SUIN_DIR_ACCESS_EXECUTE							0x00000020						// execute
// directories
#define SUIN_DIR_ACCESS_LIST							0x00000100						// list
#define SUIN_DIR_ACCESS_CREATE							0x00000200						// create
#define SUIN_DIR_ACCESS_REMOVE							0x00000400						// remove
#define SUIN_DIR_ACCESS_RENAME_DIR						0x00000800						// directory rename
// sub-directories
#define SUIN_DIR_ACCESS_SUBDIR_INHERIT					0x00001000						// sub-directories inherit from the parent
// everything set
#define SUIN_DIR_ACCESS_ALL								(SUIN_DIR_ACCESS_READ | SUIN_DIR_ACCESS_WRITE | SUIN_DIR_ACCESS_APPEND | SUIN_DIR_ACCESS_DELETE | SUIN_DIR_ACCESS_RENAME | SUIN_DIR_ACCESS_EXECUTE | SUIN_DIR_ACCESS_LIST | SUIN_DIR_ACCESS_CREATE | SUIN_DIR_ACCESS_REMOVE | SUIN_DIR_ACCESS_RENAME_DIR | SUIN_DIR_ACCESS_SUBDIR_INHERIT)
#define SUIN_DIR_ACCESS_ALL_NO_EXECUTE					(SUIN_DIR_ACCESS_ALL & (~ SUIN_DIR_ACCESS_EXECUTE))
#define SUIN_DIR_ACCESS_ALL_NO_SUBDIR_INHERIT			(SUIN_DIR_ACCESS_ALL & (~ SUIN_DIR_ACCESS_SUBDIR_INHERIT))
#define SUIN_DIR_ACCESS_DEFAULT							(SUIN_DIR_ACCESS_READ | SUIN_DIR_ACCESS_LIST | SUIN_DIR_ACCESS_SUBDIR_INHERIT)

/////////////////////////////////////////////////////////////////////////////
